//+------------------------------------------------------------------+
//|                                                  GUI_Movable.mqh |
//|                                                      Sahil Bagdi |
//|                         https://www.mql5.com/en/users/sahilbagdi |
//+------------------------------------------------------------------+
#property copyright "Sahil Bagdi"
#property link      "https://www.mql5.com/en/users/sahilbagdi"

//+------------------------------------------------------------------+
//| Class GUI_Movable                                                |
//+------------------------------------------------------------------+
class GUI_Movable
  {
private:
   int               previousMouseState, mlbDownX, mlbDownY, mlbDownXDistance, mlbDownYDistance;
   bool              movingState;
public:
		     GUI_Movable() : previousMouseState(0), mlbDownX(0), mlbDownY(0), mlbDownXDistance(0), mlbDownYDistance(0), movingState(false), Name(NULL) {};
   string            Name;
   void              OnEvent(int id, long lparam, double dparam, string sparam);
  };
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void GUI_Movable::OnEvent(int id, long lparam, double dparam, string sparam)
  {
   //Verify the event that triggered the OnChartEvent was CHARTEVENT_MOUSE_MOVE because we only want to execute out code when that is the case
   if(id == CHARTEVENT_MOUSE_MOVE)
     {
      //define X, Y, XDistance, YDistance, XSize, YSize
      int X = (int)lparam;
      int Y = (int)dparam;
      int MouseState = (int)sparam;

      string name = Name;
      int XDistance = (int)ObjectGetInteger(0, name, OBJPROP_XDISTANCE); //Should be 100 initially as we set it in OnInit()
      int YDistance = (int)ObjectGetInteger(0, name, OBJPROP_YDISTANCE); //Should be 100 initially as we set it in OnInit()
      int XSize = (int)ObjectGetInteger(0, name, OBJPROP_XSIZE); //Should be 200 initially as we set it in OnInit()
      int YSize = (int)ObjectGetInteger(0, name, OBJPROP_YSIZE); //Should be 200 initially as we set it in OnInit()

      if(previousMouseState == 0 && MouseState == 1) //Check if this was the MLB first click
        {
         mlbDownX = X; //Set mlbDownX (Variable that stores the initial MLB X location) equal to the current X
         mlbDownY = Y; //Set mlbDownY (Variable that stores the initial MLB Y location) equal to the current Y
         mlbDownXDistance = XDistance; //Set mlbDownXDistance (Variable that stores the initial XDistance i.e. Width of the dashboard) equal to the current XDistance
         mlbDownYDistance = YDistance; //Set mlbDownYDistance (Variable that stores the initial YDistance i.e. Height of the dashboard) equal to the current YDistance

         if(X >= XDistance && X <= XDistance + XSize && Y >= YDistance && Y <= YDistance + YSize) //Check if the click was on the dashboard
           {
            movingState = true; //If yes the set movingState to True
           }

        }

      if(movingState)//if movingState is true, Update the Dashboard position
        {
         ChartSetInteger(0, CHART_MOUSE_SCROLL, false);//Restrict Chart to be moved by Mouse
         ObjectSetInteger(0, name, OBJPROP_XDISTANCE, mlbDownXDistance + X - mlbDownX);//Update XDistance to: mlbDownXDistance + (X - mlbDownX)
         ObjectSetInteger(0, name, OBJPROP_YDISTANCE, mlbDownYDistance + Y - mlbDownY);//Update YDistance to: mlbDownYDistance + (Y - mlbDownY)
         ChartRedraw(0); //Redraw Chart
        }

      if(MouseState == 0)//Check if MLB is not pressed
        {
         movingState = false;//set movingState again to false
         ChartSetInteger(0, CHART_MOUSE_SCROLL, true);//allow the cahrt to be moved again
        }

      previousMouseState = MouseState;//update the previousMouseState at the end so that we can use it next time and copare it with new value
     }
  }
//+------------------------------------------------------------------+